local P1, P2, P1Score, P2Score
local difficulty, sTable
local songName= GAMESTATE:GetCurrentSong():GetSongDir() -- Looks for Song

--[[

	Some of the code below here is part of the "Preliminary Check"
	We want to just check on a couple things to ensure a safe flight

	1. Version Warning - Stepmania Versions above 5.1 seem to interpet the mods differently 
	2. Edit Chart - If the player is in Edit Mode or is on the Edit Chart, the mods do not play
	3. Mixmatch Choices - If one player is on Edit and the other is not, then both get set to Edit
		This is to ensure that no one is able to get a score on the modded charts by playing/reading an
		unmodded chart

]]--

local version = tonumber(string.match(ProductID(),'%d+%.?%d*$')) or 5.0;
if version > 5.1 then
	SCREENMAN:SystemMessage('Sorry, this song was made for SM 5.1');
end

local WideScale = function(AR4_3, AR16_9)
	-- return scale( SCREEN_WIDTH, 640, 854, AR4_3, AR16_9 )
	local w = 480 * PREFSMAN:GetPreference("DisplayAspectRatio")
	return scale( w, 640, 854, AR4_3, AR16_9 )
 end


 local function Handler_mod_internal(str, pn) -- Applies Players options to not be disabled-
	local ps= GAMESTATE:GetPlayerState(pn)
	local pmods= ps:GetPlayerOptionsString('ModsLevel_Song')
	ps:SetPlayerOptions('ModsLevel_Song', pmods .. ', ' .. str)
	--GAMESTATE:ApplyGameCommand('mod,'..str, pn)
end

local function Handler_mod(str) -- Looks for many players are on the screen 
	for i=1,2 do
		Handler_mod_internal(str, 'PlayerNumber_P' .. i)
	end
end

local function Handler_init() -- Useful for command shorcuts


	fgcurcommand = 0;
	wndr_skewx=0.3;
	checked = false;
	curmod = 1;		
	--{beat,'mod'},
	mods = {
		{17,' *10 60% Beat, *1 5% Tipsy'},

	}
	--SCREAMING GUMBALL / timed message broadcaster
	curmessage = 1;
	--{beat,message,ignoreIfAhead}
	messages = {
		{88.25, 'Show'},
		{95.25, 'Show'},
		{103.25, 'Show'},
		--{113, 'Show'},
		{120.25, 'Show'},
		{127.25, 'Show'},
		{135.25, 'Show'},
		{161.25, 'Show'},
		{161.40, 'Fireworks'},
		{177.25, 'Show'},
		{177.30, 'ShowSun'},
		{216.25, 'Show'},
		{223.25, 'Show'},
		{231.25, 'Show'},
		{240.25, 'Show'},
		{247.25, 'Show'},
		{255.25, 'Show'},
		{263.25, 'Show'},
		{272.25, 'Show'},
		{298.25, 'Show'},
		{306.25, 'Show'},
		{314.25, 'Show'},
		{330.25, 'Show'},
		{339.25, 'Show'},
		{347.25, 'Show'},
		
		--{111.75, 'RotateEm'},

	}
	
end

local function Handler_update() -- Updates the command to look for the players at the start of the song.

	if GAMESTATE:GetSongBeat()>=0.1 and not checked then
		
		screen = SCREENMAN:GetTopScreen()
		
		checked = true;
		
	end

	local beat = GAMESTATE:GetSongBeat()
	--SM(beat)
	-- Collect all the mods that will be applied in this frame into one string.
	-- Mod tweening doesn't work correctly if the mods are in seperate commands.
	local mods_this_frame= {}
	local function add_mod(mod_str)
		mods_this_frame[#mods_this_frame+1]= mod_str
	end
	local function execute_mods()
		if #mods_this_frame <= 0 then return end
		local total_mod_str= ""
		for i, ms in ipairs(mods_this_frame) do
			if #total_mod_str > 0 then
				total_mod_str= total_mod_str .. ", "
			end
			total_mod_str= total_mod_str .. ms
		end
		Handler_mod(total_mod_str)
	end
	
	while curmod<= #mods and GAMESTATE:GetSongBeat()>=mods[curmod][1] do
		add_mod(mods[curmod][2])
		curmod = curmod+1
	end

	execute_mods()
	
	while curmessage<= #messages and GAMESTATE:GetSongBeat()>=messages[curmessage][1] do
		if messages[curmessage][3] and GAMESTATE:GetSongBeat()>=messages[curmessage][1]+5 then
			curmessage = curmessage+1;
		else
			MESSAGEMAN:Broadcast(messages[curmessage][2])
			curmessage = curmessage+1;
		end
	end
end
local last_score_x = 0
local musicrate = GAMESTATE:GetSongOptionsObject("ModsLevel_Song"):MusicRate()
return Def.ActorFrame{

	OnCommand= function(self)
			Handler_init()
			self:SetUpdateFunction(Handler_update)
			local screen = SCREENMAN:GetTopScreen()
			-- Fade out everything but the SongBackground, SongForeground, and Player layers.
			-- In Simply Love (as of v4.8.5 anyway), player combos will unhide themselves,
			-- but that's okay for this stepchart.  If you need to hide combos in SL, call
			-- hibernate(math.huge) on each.  Sorry about that.
			-- don't fade out the theme's UI in EditMode

		end,
	Def.Quad{
		Name= "I may be sleeping, but I preserve the world.",
		InitCommand= cmd(visible,false),
		OnCommand= cmd(sleep,1000),
	},

	LoadActor("_dead"),
	
	Def.Quad {
			InitCommand=function(self)
				self:x(SCREEN_CENTER_X):y(SCREEN_CENTER_Y):zoomto(SCREEN_WIDTH,SCREEN_HEIGHT):diffuse(color("#000000"))
			end;
			OnCommand=function(self)
				self:decelerate(0.4):diffusealpha(0)
			end;
	},
	
}